% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_tree.R
\name{validate_sets}
\alias{validate_sets}
\title{Validate sets of transmission trees}
\usage{
validate_sets(sets)
}
\arguments{
\item{sets}{A list where each element represents a set of transmission trees. Each set must be a list
containing one or more data frames.}
}
\value{
Invisible \code{TRUE} if the sets are valid. Throws an error if invalid.
}
\description{
Checks that the provided input is a list of at least two valid sets of transmission trees.
Each set is expected to be a list containing at least one data frame, as verified by
\code{\link{validate_set}}.
}
\details{
At least two sets are provided.
Each set is a list (and not a data frame itself).
Each set contains at least one element.
Every element in each set is a data frame.
}
\seealso{
\code{\link{validate_set}} for validating an individual set.
}
\keyword{internal}
