% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node.R, R/ctx_node_cpp.R
\name{counts}
\alias{counts}
\alias{counts.ctx_node}
\alias{counts.ctx_node_cpp}
\title{Report the distribution of values that follow occurrences of a sequence}
\usage{
counts(node, frequency = c("detailed", "total"), local = FALSE)

\method{counts}{ctx_node}(node, frequency = c("detailed", "total"), local = FALSE)

\method{counts}{ctx_node_cpp}(node, frequency = c("detailed", "total"), local = FALSE)
}
\arguments{
\item{node}{a \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}}

\item{frequency}{specifies the counts to be included in the result. \code{"total"}
gives the number of occurrences of the sequence in the original sequence.
\code{"detailed"} includes in addition the break down of these occurrences into
all the possible states.}

\item{local}{specifies how the counts are computed. When \code{local} is \code{FALSE}
(default value) the counts include both counts that are specific to the
context (if any) and counts from the descendants of the context in the
tree. When \code{local} is \code{TRUE} the counts include only the number of times
the context appears without being the last part of a longer context.}
}
\value{
either an integer when \code{frequency="total"} which gives the total
number of occurrences of the sequence represented by \code{node} or a
\code{data.frame} with a \code{total} column with the same value and a column for
each of the possible value of the original time series, reporting counts in
each column (see the description above).
}
\description{
This function reports the number of occurrences of the sequence represented
by \code{node} in the original time series used to build the associated context
tree (not including a possible final occurrence not followed by any value at
the end of the original time series). In addition if \code{frequency=="detailed"},
the function reports the frequencies of each of the possible value of the
time series when they appear just after the sequence.
}
\examples{
dts <- sample(as.factor(c("A", "B", "C")), 100, replace = TRUE)
dts_tree <- ctx_tree(dts, max_depth = 3, min_size = 5)
subseq <- find_sequence(dts_tree, factor(c("A", "A"), levels = c("A", "B", "C")))
if (!is.null(subseq)) {
  counts(subseq)
}
}
\seealso{
\code{\link[=contexts]{contexts()}} and \code{\link[=contexts.ctx_tree]{contexts.ctx_tree()}}
}
