% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contexts.R
\name{print.contexts}
\alias{print.contexts}
\title{Print a context list}
\usage{
\method{print}{contexts}(x, reverse = TRUE, ...)
}
\arguments{
\item{x}{the \code{contexts} object to print}

\item{reverse}{specifies whether the contexts should be reported in
temporal order (\code{FALSE}, default value) or in reverse temporal order (\code{TRUE}).
If the parameter is not specified, the contexts are displayed in order
specified by the call to \code{contexts()} used to build the context list.}

\item{...}{additional arguments for the print function.}
}
\value{
the \code{x} object, invisibly
}
\description{
This function prints a list of contexts i.e. a \code{contexts} object listing
\code{ctx_node} objects.
}
\examples{
dts <- c("A", "B", "C", "A", "A", "B", "B", "C", "C", "A")
dts_tree <- ctx_tree(dts, max_depth = 3)
print(contexts(dts_tree))
}
\seealso{
\code{\link[=contexts]{contexts()}}
}
