% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitching.R
\name{aera}
\alias{aera}
\title{Calculates adjusted earned run average (ERA+)}
\usage{
aera(er, ip, lera, home_rs, home_ra, home_r, road_rs, road_ra, road_r)
}
\arguments{
\item{er}{Number of runs that did not occur as a result of errors or passed balls}

\item{ip}{Number of innings pitched}

\item{lera}{Average league ERA}

\item{home_rs}{Number of pitcher's team runs scored at home park}

\item{home_ra}{Number of pitcher's team runs allowed at home park}

\item{home_r}{Total number of runs scored at home park}

\item{road_rs}{Number of pitcher's team runs scored at away park}

\item{road_ra}{Number of pitcher's team runs allowed at away park}

\item{road_r}{Total number of runs scored at away park}
}
\value{
aera
}
\description{
Computes adjusted earned run average accounting for park factor and league era (compare with "era" which is the traditional formula for earned run average, "erc" which is the component earned run average, or "dice" which is the defense-independent component earned run average)
}
\examples{
aera(10, 5.5, 2.5, 8, 7, 15, 6, 4, 10) # for a pair of games (one away, one home)
}
