% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_knn.R
\name{mlKnn}
\alias{mlKnn}
\alias{ml_knn}
\alias{mlKnn.formula}
\alias{mlKnn.default}
\alias{summary.mlKnn}
\alias{print.summary.mlKnn}
\alias{predict.mlKnn}
\title{Supervised classification using k-nearest neighbor}
\usage{
mlKnn(train, ...)

ml_knn(train, ...)

\method{mlKnn}{formula}(formula, data, k.nn = 5, ..., subset, na.action)

\method{mlKnn}{default}(train, response, k.nn = 5, ...)

\method{summary}{mlKnn}(object, ...)

\method{print}{summary.mlKnn}(x, ...)

\method{predict}{mlKnn}(
  object,
  newdata,
  type = c("class", "prob", "both"),
  method = c("direct", "cv"),
  na.action = na.exclude,
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to the classification method or its
\code{\link[=predict]{predict()}} method (not used here for now).}

\item{formula}{a formula with left term being the factor variable to predict
and the right term with the list of independent, predictive variables,
separated with a plus sign. If the data frame provided contains only the
dependent and independent variables, one can use the \code{class ~ .} short
version (that one is strongly encouraged). Variables with minus sign are
eliminated. Calculations on variables are possible according to usual formula
convention (possibly protected by using \code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{k.nn}{k used for k-NN number of neighbor considered. Default is 5.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_knn]{ml_knn()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor for the classification.}

\item{x, object}{an \strong{mlKnn} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"prob"} the "probability" for the
different classes as assessed by the number of neighbors of these classes,
or \code{"both"} to return classes and "probabilities",}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases in
\verb{newdata=} if this argument is provided, or the cases in the training set
if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different data set in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_knn]{ml_knn()}}/\code{\link[=mlKnn]{mlKnn()}} creates an \strong{mlKnn}, \strong{mlearning} object
containing the classifier and a lot of additional metadata used by the
functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the k-nearest neighbor
algorithm provided by \code{\link[class:knn]{class::knn()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_knn <- ml_knn(data = iris_train, Species ~ .)
summary(iris_knn)
predict(iris_knn) # This object only returns classes
# Self-consistency, do not use for assessing classifier performances!
confusion(iris_knn)
# Use an independent test set instead
confusion(predict(iris_knn, newdata = iris_test), iris_test$Species)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also \code{\link[class:knn]{class::knn()}} and
\code{\link[ipred:predict.ipredknn]{ipred::predict.ipredknn()}} that actually do the classification.
}
