% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_frechet.R
\encoding{UTF-8}
\name{dis_frechet}
\alias{dis_frechet}
\title{Constructs a pairwise distance matrix based on the Frechet distance}
\usage{
dis_frechet(X, ...)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{...}{Additional parameters for the function. See  \code{\link[TSclust]{diss.FRECHET}}.}
}
\value{
The computed pairwise distance matrix.
}
\description{
\code{dis_frechet} returns a pairwise distance matrix based on the Frechet distance
between MTS
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the sum of the standard
Frechet distances between each corresponding pair of dimensions (univariate
time series)
}
\examples{
toy_dataset <- Libras$data[1 : 5] # Selecting the first 5 MTS from the
# dataset Libras
distance_matrix <- dis_frechet(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_frechet
}
\seealso{
\code{\link[TSclust]{diss.FRECHET}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
