% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairness_accuracy_tradeoff.R
\name{fairness_accuracy_tradeoff}
\alias{fairness_accuracy_tradeoff}
\title{Plot Fairness Accuracy Trade-offs}
\usage{
fairness_accuracy_tradeoff(object, ...)
}
\arguments{
\item{object}{(\link[mlr3:PredictionClassif]{mlr3::PredictionClassif} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} | \link[mlr3:ResampleResult]{mlr3::ResampleResult})\cr
The binary class prediction object that will be evaluated.
\itemize{
\item If provided a \link[mlr3:PredictionClassif]{mlr3::PredictionClassif}.
Then only one point will indicate the accuracy and fairness metrics for the current predictions.
Requires also passing a \link[mlr3:Task]{mlr3::Task}.
\item If provided a \link[mlr3:ResampleResult]{mlr3::ResampleResult}.
Then the plot will compare the accuracy and fairness metrics for the same model,
but different resampling iterations  as well as the aggregate indicated by a cross.
\item If provided a \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}.
Then the plot will compare the accuracy and fairness metrics for all models and all resampling iterations.
Points are colored according to the learner_id and faceted by task_id.
The aggregated score is indicated by a cross.
}}

\item{...}{Arguments to be passed to methods. Such as:
\itemize{
\item \code{fairness_measure} (\link[mlr3:Measure]{mlr3::Measure})\cr
The fairness measures that will evaluated.
Default measure set to be \code{msr("fairness.fpr")}
\item \code{accuracy_measure} (\link[mlr3:Measure]{mlr3::Measure})\cr
The accuracy measure that will evaluated.
Default measure set to be \link[mlr3:MeasureClassif]{msr("classif.acc")}.
\item \code{task} (\link[mlr3:TaskClassif]{mlr3::TaskClassif})\cr
The data task that contains the protected column, only required
when the class of object is (\link[mlr3:PredictionClassif]{mlr3::PredictionClassif})
}}
}
\value{
A 'ggplot2' object.
}
\description{
Provides visualization wrt. trade-offs between fairness and accuracy metrics across learners and
resampling iterations.
This can assist in gauging the optimal model from a set of options along with estimates of variance
(through individual resampling iterations).
}
\section{Protected Attributes}{

The protected attribute is specified as a \code{col_role} in the corresponding \code{\link[mlr3:Task]{mlr3::Task()}}:\cr
\verb{<Task>$col_roles$pta = "name_of_attribute"} \cr
This also allows specifying more than one protected attribute,
in which case fairness will be considered on the level of intersecting groups defined by all columns
selected as a predicted attribute.
}

\examples{
\dontshow{if (rlang::is_installed("rpart") && rlang::is_installed("ranger")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("mlr3")
library("mlr3learners")
library("ggplot2")

# Setup the Fairness measure and tasks
task = tsk("adult_train")$filter(1:500)
learner = lrn("classif.ranger", predict_type = "prob")
fairness_measure = msr("fairness.tpr")

# Example 1 - A single prediction
learner$train(task)
predictions = learner$predict(task)
fairness_accuracy_tradeoff(predictions, fairness_measure, task = task)

# Example2 - A benchmark
design = benchmark_grid(
  tasks = task,
  learners = lrns(c("classif.featureless", "classif.rpart"),
    predict_type = "prob", predict_sets = c("train", "test")),
  resamplings = rsmps("cv", folds = 2)
)
bmr = benchmark(design)
fairness_accuracy_tradeoff(bmr, fairness_measure)
\dontshow{\}) # examplesIf}
}
