% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape.R
\name{infer_shapes}
\alias{infer_shapes}
\title{Infer Shapes}
\usage{
infer_shapes(shapes_in, param_vals, output_names, fn, rowwise, id)
}
\arguments{
\item{shapes_in}{(\code{list()})\cr
A list of shapes of the input tensors.}

\item{param_vals}{(\code{list()})\cr
A list of named parameters for the function.}

\item{output_names}{(\code{character()})\cr
The names of the output tensors.}

\item{fn}{(\verb{function()})\cr
The function to infer the shapes for.}

\item{rowwise}{(\code{logical(1)})\cr
Whether the function is rowwise.}

\item{id}{(\code{character(1)})\cr
The id of the PipeOp (for error messages).}
}
\value{
(\code{list()})\cr
A list of shapes of the output tensors.
}
\description{
Infer the shapes of the output of a function based on the shapes of the input.
This is done as follows:
\enumerate{
\item All \code{NA}s are replaced with values \code{1}, \code{2}, \code{3}.
\item Three tensors are generated for the three shapes of step 1.
\item The function is called on these three tensors and the shapes are calculated.
\item If:
\itemize{
\item the number of dimensions varies, an error is thrown.
\item the number of dimensions is the same, values are set to \code{NA} if the dimension is varying
between the three tensors and otherwise set to the unique value.
}
}
}
