% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrogates.R
\name{makeMlr3Surrogate}
\alias{makeMlr3Surrogate}
\title{Create Surrogate Learner}
\usage{
makeMlr3Surrogate(
  is.numeric = TRUE,
  is.noisy = TRUE,
  has.dependencies = !is.numeric
)
}
\arguments{
\item{is.numeric}{(\code{logical(1)})\cr
Whether only numeric parameters are present. If so, a \code{LearnerRegrKM} (\pkg{DiceKriging} package)
is constructed. Otherwise a \code{LearnerRegrRanger} (random forest from the \pkg{ranger} package) is constructed.
Default is \code{TRUE}.}

\item{is.noisy}{(\code{logical(1)})\cr
Whether to use nugget estimation. Only considered when \code{is.numeric} is \code{TRUE}. Default is \code{TRUE}.}

\item{has.dependencies}{(\code{logical(1)})\cr
Whether to anticipate missing values in the surrogate model design. This adds out-of-range imputation to the model.
If more elaborate imputation is desired, it may be desirable to set this to \code{FALSE} and instead perform custom imputation
using \pkg{mlr3pipelines}.
Default is \code{!numeric}.}
}
\description{
Creates the default mlrMBO surrogate learners as an \code{\link[mlr3:Learner]{mlr3::Learner}}.

This imitates the behaviour of mlrCPO when no \code{learner} argument is given to \code{mbo()} / \code{initSMBO()}.
}
\examples{
# DiceKriging Learner:
makeMlr3Surrogate()

# mlr3pipelines Graph: imputation \%>>\% 'ranger' (randomForest):
makeMlr3Surrogate(is.numeric = FALSE)

# just the 'ranger' Learner:
makeMlr3Surrogate(is.numeric = FALSE, has.dependencies = FALSE)

}
