% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_MLmodels.R
\name{train_rf}
\alias{train_rf}
\title{Train Random Forest model}
\usage{
train_rf(data, formula, ntree = 500, seed = 123)
}
\arguments{
\item{data}{A data frame containing the training data.}

\item{formula}{A formula describing the model structure.}

\item{ntree}{Number of trees to grow (default 500).}

\item{seed}{Random seed for reproducibility (default 123).}
}
\value{
A trained randomForest model object.
}
\description{
Trains a Random Forest regression model.
}
\examples{
\donttest{
library(randomForest)
data(mtcars)
rf_model <- train_rf(mtcars, mpg ~ cyl + hp + wt, ntree = 100)
print(rf_model)
}
}
