% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{Mean Square Error}
\usage{
mse(preds = NULL, actuals = NULL, weights = 1, na.rm = FALSE)
}
\arguments{
\item{preds}{A vector of prediction values in [0, 1]}

\item{actuals}{A vector of actuals values in {0, 1}, or {FALSE, TRUE}}

\item{weights}{Optional vectors of weights}

\item{na.rm}{Should (prediction, actual) pairs with at least one NA value be ignored?}
}
\description{
Calculate Mean-Square Error (Deviation)

For the ith sample, Squared Error is calculated as SE = (prediction - actual)^2. MSE is then mean(squared errors).
}
\details{
Calculate Mean-Square Error (Deviation)
}
\examples{
preds <- c(1.0, 2.0, 9.5)
actuals <- c(0.9, 2.1, 10.0)
mse(preds, actuals)

}
\references{
\url{https://en.wikipedia.org/wiki/Mean_squared_error}
}
