% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{generate_study_data}
\alias{generate_study_data}
\title{Generate Study Data for RepliCrisis}
\usage{
generate_study_data(x, sample_size)
}
\arguments{
\item{x}{A matrix with two rows representing the mean and standard deviation
for each group.}

\item{sample_size}{The number of samples to draw for each study group.}
}
\value{
A data frame containing the simulated study data. Each row corresponds
to a single sample and includes the group label and the sampled value.
}
\description{
This function simulates data for the Replication Crisis study by drawing samples
from normal distributions defined by the card values.
}
\details{
The function expects a matrix \code{x} generated from deal_cards_to_rc_grid() where
the first row contains mean values and the second row contains standard deviation
values. It then generates \code{sample_size} number of normal random values for each
group, using the respective mean and standard deviation. The resulting data
frame has two columns: one for the group labels and one for the generated values.

The group labels are factors with levels corresponding to the column numbers
prefixed by 'Col'. The generated values are numeric and simulate the data that
would be collected in the study. The function uses the \code{rnorm} function from
the \code{stats} package for generating random samples.
}
\examples{
study_data <- generate_study_data(x = deal_cards_to_rc_grid(n = 3),
                                  sample_size = 30)
}
