% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ednn_basis_functions.R
\name{EDNN}
\alias{EDNN}
\title{Encoder decoder neural network (EDNN) function}
\usage{
EDNN(
  X,
  Y,
  Xtest,
  embedding_size = 2,
  epochs = 10,
  batch_size = 5,
  l2reg = 0,
  demo = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{X}{concatenated adjacency matrices for different layers containing the nodes in training phase}

\item{Y}{concatenated random walk probability matrices for different layers containing the nodes in training phase}

\item{Xtest}{concatenated adjacency matrices for different layers containing the nodes in test phase. Can be = \emph{X} for transductive inference.}

\item{embedding_size}{the dimension of embedding space, equal to the number of the bottleneck hidden nodes.}

\item{epochs}{maximum number of pocks. An early stopping callback with a patience of 5 has been set inside the function (default = 10).}

\item{batch_size}{batch size for learning (default = 5).}

\item{l2reg}{the coefficient of L2 regularization for the input layer (default = 0).}

\item{demo}{a boolean vector to indicate this is a demo example or not}

\item{verbose}{if \emph{TRUE} a progress bar is shown.}
}
\value{
The embedding space for Xtest.
}
\description{
Encoder decoder neural network (EDNN) function
}
\examples{
myNet = network_gen(N_nodes = 50)
graphData = myNet[["data_graph"]]
edge.list = graphData[,1:2]
edge.weight = graphData[,3:4]
XY = ednn_IOprepare(edge.list, edge.weight)
X = XY[["X"]]
Y = XY[["Y"]]
embeddingSpace = EDNN(X = X, Y = Y, Xtest = X)

}
