% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnonr.R
\name{mnonr}
\alias{mnonr}
\title{Multivariate Non-normal Random Number Generator based on Multivariate Measures}
\usage{
mnonr(n, p, ms, mk, Sigma, initial = NULL)
}
\arguments{
\item{n}{Sample size}

\item{p}{Number of variables}

\item{ms}{A value of multivariate skewness}

\item{mk}{A value of multivariate kurtosis}

\item{Sigma}{A covariance matrix (In this function, the generated data are standarized. A correlation matrix is equal to its corresponding covariance matrix.)}

\item{initial}{A vector with 3 numbers for initial polynominal coefficients' (b,c,d). The default setting is (0.9,0.4,0).}
}
\value{
A data matrix (multivariate data)
}
\description{
Multivariate Non-normal Random Number Generator based on Multivariate Measures
}
\examples{
mnonr::mnonr(n=10000,p=2,ms=3,mk=61,Sigma=matrix(c(1,0.5,0.5,1),2,2),initial=NULL)
}
