% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{KKurt}
\alias{KKurt}
\title{Koziols measure of multivariate sample kurtosis}
\usage{
KKurt(data)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}
}
\value{
value of sample kurtosis in the sense of Koziol.
}
\description{
This function computes the invariant measure of multivariate sample kurtosis due to Koziol (1989).
}
\details{
Multivariate sample kurtosis due to Koziol (1989) is defined by
\deqn{\widetilde{b}_{n,d}^{(2)}=\frac{1}{n^2}\sum_{j,k=1}^n(Y_{n,j}^\top Y_{n,k})^4,}
where \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{j=1,\ldots,n}, are the scaled residuals, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error. Note that for \eqn{d=1}, we have a measure proportional to the squared sample kurtosis.
}
\examples{
KKurt(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Koziol, J.A. (1989), A note on measures of multivariate kurtosis, Biom. J., 31:619–624.
}
