% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC.R
\name{cv.quan}
\alias{cv.quan}
\title{Monte Carlo simulation of quantiles for normality tests}
\usage{
cv.quan(
  samplesize,
  dimension,
  quantile,
  statistic,
  tuning = NULL,
  repetitions = 1e+05
)
}
\arguments{
\item{samplesize}{samplesize for which the empirical quantile should be calculated.}

\item{dimension}{a natural number to specify the dimension of the multivariate normal distribution}

\item{quantile}{a number between 0 and 1 to specify the quantile of the empirical distribution of the considered test}

\item{statistic}{a function specifying the test statistic.}

\item{tuning}{the tuning parameter of the test statistic.}

\item{repetitions}{number of Monte Carlo runs.}
}
\value{
empirical quantile of the test statistic.
}
\description{
This function returns the quantiles of a test statistic with optional tuning parameter.
}
\examples{
cv.quan(samplesize=10, dimension=2,quantile=0.95, statistic=BHEP, tuning=2.5, repetitions=1000)

}
