% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_many.R
\name{fit_many}
\alias{fit_many}
\title{Fit a List of Models}
\usage{
fit_many(
  model_list,
  sem_out,
  original = NULL,
  parallel = FALSE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{model_list}{A list of parameter
tables to be used by
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} or \code{\link[=update]{update()}}.
Usually generated by \code{\link[=get_add]{get_add()}} or
\code{\link[=get_drop]{get_drop()}}.}

\item{sem_out}{The output from an
structural equation modeling
function. It currently supports
\link[lavaan:lavaan-class]{lavaan::lavaan} objects
only. Usually
the one used in \code{\link[=model_set]{model_set()}},
\code{\link[=get_add]{get_add()}} or
\code{\link[=get_drop]{get_drop()}} to generate the list of
models.}

\item{original}{String. If provided,
it should be a name of a model
in \code{model_list}, with which
differences in model degrees of
freedom will be computed for other
models. If \code{NULL}, the default,
then the model in \code{sem_out} will
be used to computed the differences
in model degrees of freedom. If \code{NA},
then differences in model \emph{df} will
not be computed.}

\item{parallel}{If \code{TRUE}, parallel
processing will be used to fit the
models. Default is \code{FALSE}.}

\item{ncores}{Numeric. The number of
CPU cores to be used if \code{parallel}
is \code{TRUE}.}

\item{make_cluster_args}{A list of
named arguments to be passed to
\code{parallel::makeCluster()}. Used by
advanced users to configure the
cluster if \code{parallel} is \code{TRUE}.
Default is \code{list()}.}

\item{progress}{Whether a progress
bar will be displayed, implemented
by the \code{pbapply} package. Default
is \code{TRUE}.}

\item{verbose}{Whether additional
messages will be displayed, such
as the expected processing time.
Default is \code{TRUE}.}
}
\value{
An object of the class
\code{sem_outs}, a list with the
following major elements:
\itemize{
\item \code{fit}: A named list of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} output objects or
\code{\link[=update]{update()}} for fitting a model with
the added parameters.
\item \code{change}: A numeric vector, of the
same length as \code{fit}. The change
in model \emph{df} for each fit compared
to the original model. A
positive number denotes one less
free parameter. A negative number
denotes one more free parameter or
one less constraint.
\item \code{converged}: A named vector of
boolean values, of the same length
as \code{fit}. Indicates whether each
fit converged or not.
\item \code{post_check}: A named vector of
boolean values, of the same length
as \code{fit}. Indicates whether the
solution of each fit is
admissible or not. Checked by
\code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} with
the \code{what} argument set to
\code{"post.check"}.
}
}
\description{
Fit a list of models
to a dataset.
}
\details{
It receives a list of
models, defined by \code{lavaan} parameter
tables (usually generated by
\code{\link[=model_set]{model_set()}}, \code{\link[=get_add]{get_add()}} or
\code{\link[=get_drop]{get_drop()}}),
and fit them to a dataset stored
in a \code{lavaan}-class object.

This function is called by
\code{\link[=model_set]{model_set()}} and usually users do
not need to call it. It is exported
for advanced users.
}
\examples{

library(lavaan)
dat <- dat_path_model
mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"
fit <- sem(mod, dat_path_model, fixed.x = TRUE)
mod_to_add <- get_add(fit)
fit_many(mod_to_add, fit)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
