% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_sd_th.R
\name{bootstrap_sd_th}
\alias{bootstrap_sd_th}
\title{Bootstrap standard deviation for the slope of a psychometric function}
\usage{
bootstrap_sd_th( TH, r, m, x, N, h0, X = (max(x)-min(x))*(0:999)/999+min(x),
                 link = "logit", guessing = 0, lapsing = 0, K = 2, p = 1,
                 ker = "dnorm", maxiter = 50, tol = 1e-6 )
}
\arguments{
\item{TH}{required threshold level}

\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{N}{number of bootstrap replications; N should be at least 200 for reliable results}

\item{h0}{bandwidth}

\item{X}{(optional) set of values at which estimates of the psychometric function for the threshold estimation are to be obtained; if not given, 1000 equally spaced points from minimum to maximum of 'x' are used}

\item{link}{(optional) name of the link function; default is "logit"}

\item{guessing}{(optional) guessing rate; default is 0}

\item{lapsing}{(optional) lapsing rate; default is 0}

\item{K}{(optional) power parameter for Weibull and reverse Weibull link; default is 2}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{ker}{(optional) kernel function for weights; default is "dnorm"}

\item{maxiter}{(optional) maximum number of iterations in Fisher scoring; default is 50}

\item{tol}{(optional) tolerance level at which to stop Fisher scoring; default is 1e-6}
}
\value{
\verb{sd   } bootstrap estimate of the standard deviation of the threshold estimator

\verb{th0  } threshold estimate
}
\description{
The function finds a bootstrap estimate of the standard deviation of the estimated
threshold for the local polynomial estimate of the psychometric function with
guessing and lapsing rates.
}
\examples{
\donttest{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
bwd_min <- min( diff( x ) )
bwd_max <- max( x ) - min( x )
bwd <- bandwidth_cross_validation( r, m, x, c( bwd_min, bwd_max ), method = "deviance" )
prob <- 0.5 # Required threshold level
# This might take a few minutes
niter <- 200 # Note number of bootstrap iterations should be at least 200
th_sl <- bootstrap_sd_sl( prob, r, m, x, niter, bwd ) # Be patient, slow process
}
}
