% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_revenue.R
\name{cost_revenue}
\alias{cost_revenue}
\title{Calculate cost and revenue}
\usage{
cost_revenue(
  x,
  fixed_cost = 0,
  var_cost = 0,
  tp_val = 0,
  prob_col = NA,
  truth_col = NA
)
}
\arguments{
\item{x}{A data frame containing predicted probabilities of a target event and the actual outcome/class.}

\item{fixed_cost}{Fixed cost (e.g. of a campaign)}

\item{var_cost}{Variable cost (e.g. discount offered)}

\item{tp_val}{The average value of a True Positive}

\item{prob_col}{The unquoted name of the column with probabilities of the event of interest.}

\item{truth_col}{The unquoted name of the column with the actual outcome/class. Possible values are 'Yes' and 'No'.}
}
\value{
A data frame with the following columns:

row       = row numbers \cr
pct       = percentiles \cr
cost_sum  = cumulated costs \cr
cum_rev   = cumulated revenue
}
\description{
Calculates cost and revenue after sorting observations.
}
\examples{
cost_revenue(predictions,
   fixed_cost = 1000,
   var_cost   = 100,
   tp_val     = 2000,
   prob_col   = Yes,
   truth_col  = Churn)
}
