% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode-proper.R
\name{mode_all}
\alias{mode_all}
\title{All modes}
\usage{
mode_all(x, na.rm = FALSE)
}
\arguments{
\item{x}{A vector to search for its modes.}

\item{na.rm}{Boolean. Should missing values in \code{x} be removed before
computation proceeds? Default is \code{FALSE}.}
}
\value{
A vector with all modes (values tied for most frequent) in \code{x}. If
the modes can't be determined because of missing values,
returns \code{NA} instead.
}
\description{
\code{mode_all()} returns the set of all modes in a vector.
}
\examples{
# Both `3` and `4` are the modes:
mode_all(c(1, 2, 3, 3, 4, 4))

# Only `8` is:
mode_all(c(8, 8, 9))

# Can't determine the modes here --
# `9` might be another mode:
mode_all(c(8, 8, 9, NA))

# Either `1` or `2` could be a
# single mode, depending on `NA`:
mode_all(c(1, 1, 2, 2, NA))

# `1` is the most frequent value,
# no matter what `NA` stands for:
mode_all(c(1, 1, 1, 2, NA))

# Ignore `NA`s with `na.rm = TRUE`
# (there should be good reasons for this!):
mode_all(c(8, 8, 9, NA), na.rm = TRUE)
mode_all(c(1, 1, 2, 2, NA), na.rm = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=mode_first]{mode_first()}} for the first-appearing mode.
\item \code{\link[=mode_single]{mode_single()}} for the \emph{only} mode, or \code{NA} if there are more.
}
}
