% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralityClustering.R
\name{CentralityAndClustering}
\alias{CentralityAndClustering}
\alias{centTable}
\alias{clustTable}
\title{Create table of centrality values or clustering coefficients}
\usage{
centTable(
  Wmats,
  scale = TRUE,
  which.net = "temporal",
  labels = NULL,
  relative = FALSE,
  weighted = TRUE,
  signed = TRUE
)

clustTable(Wmats, scale = TRUE, labels = NULL, relative = FALSE, signed = TRUE)
}
\arguments{
\item{Wmats}{Output from one of the primary \code{modnets} functions.}

\item{scale}{Logical. Determines whether to standardize values within each
measure (i.e., convert to z-scores).}

\item{which.net}{Only applies to SUR networks, as well as those fit with the
\code{\link{mlGVAR}} function. Character string to indicate which type of
network to compute centrality values for. Options are \code{"temporal"} for
the temporal network, \code{"contemporaneous"} for the contemporaneous
network, \code{"PDC"} for the partial directed correlation network, and
\code{"interactions"} for the temporal interaction network.}

\item{labels}{Character vector to input the names of the nodes. If left
\code{NULL}, the function defaults to the node names specified by the
model.}

\item{relative}{Logical. Determines whether to scale values within each
measure relative to the largest value within that measure.}

\item{weighted}{Logical. If \code{TRUE} then results are converted to an
unweighted network.}

\item{signed}{Logical. Determines whether to ignore the signs of edges or
not. Primarily affects the output for expected influence statistics.}
}
\value{
A table containing the names of nodes, measures of node centrality,
and their corresponding centrality values or clustering coefficients.
}
\description{
Mimics the output of the
\code{\link[qgraph:centralityTable]{qgraph::centralityTable}} and
\code{\link[qgraph:clusteringTable]{qgraph::clusteringTable}} functions. The
purpose of revising these function was to make them compatible with outputs
from the \code{modnets} package.
}
\details{
For \code{\link{centTable}}, centrality values can be computed for the matrix
of interactions within a temporal network.
}
\examples{
x <- fitNetwork(gvarDat, 'M', lags = TRUE)

clustTable(x)
centTable(x, which.net = 'interactions')
}
\seealso{
\code{\link{centAuto}, \link{clustAuto}, \link{centPlot},
  \link{clustPlot}, \link{plotCentrality},
  \link[qgraph:centralityTable]{qgraph::centralityTable},
  \link[qgraph:clusteringTable]{qgraph::clusteringTable}}
}
