% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopwords.R
\name{stopwords}
\alias{stopwords}
\title{Collection of stopwords in multiple languages}
\usage{
stopwords(lang = "en")
}
\arguments{
\item{lang}{Language for which to retrieve the stop word among those supported. This parameters supports: \itemize{
 \item three-letter ISO 639-2/3 codes (e.g., \code{'eng'});
 \item two-letter ISO639-1 codes (\code{'en'});
 \item names based ISO 639-2 codes (\code{'English'} or \code{'english'}) and their unambiguous substrings (\code{'engl'}, \code{'engli'}, etc.).
}}
}
\value{
A character vector containing the stop words from the selected language as listed in the \href{https://github.com/stopwords-iso/stopwords-iso}{StopwordISO} repository.
}
\description{
This function returns stop words contained in the \href{https://github.com/stopwords-iso/stopwords-iso}{StopwordsISO} repository.
}
\examples{
# They all return the correct list of stop words!

stopwords('German')
stopwords('germ')
stopwords('de')
stopwords('deu')
}
