% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-PPC.R
\name{PlotPPC}
\alias{PlotPPC}
\alias{plot.PPC}
\title{Plot the Posterior Predictive Chack on an object \code{PPC}}
\usage{
\method{plot}{PPC}(
  x,
  xlab = "Observation",
  ylab = "Prediction",
  main = NULL,
  dodge.width = 0,
  ...
)
}
\arguments{
\item{x}{an object of class \code{PPC}}

\item{xlab}{label of the x-axis}

\item{ylab}{label of the y-axis}

\item{main}{title of the graphic}

\item{dodge.width}{dodging width. Dodging preserves the vertical position
of an geom while adjusting the horizontal position.
See \code{\link[ggplot2]{position_dodge}} for further details.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{\link[ggplot2]{ggplot}}
}
\description{
This is the generic \code{plot} S3 method for the \code{PPC} class.
It plots the predicted values with 95 \\% credible intervals versus the observed
values for \code{FitTT} objects.

The coordinates of black points are the observed values of the number of survivors
(pooled replicates) for a given concentration (\eqn{X}-axis) and the corresponding
predicted values (\eqn{Y}-axis). 95\\% prediction intervals are added to each predicted
value, colored in green if this interval contains the observed value and in red
otherwise.
The bisecting line (y = x) is added to the plot in order to see if each
prediction interval contains each observed value. As replicates are shifted
on the x-axis, this line is represented by steps.
}
