% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDoseResponse.reproData.R
\name{plotDoseResponse.reproData}
\alias{plotDoseResponse.reproData}
\title{Plot dose-response from \code{reproData} objects}
\usage{
\method{plotDoseResponse}{reproData}(
  x,
  xlab = "Concentration",
  ylab = "Nb of offspring per ind.day",
  main = NULL,
  ylim = NULL,
  target.time = NULL,
  style = "ggplot",
  log.scale = FALSE,
  remove.someLabels = FALSE,
  axis = TRUE,
  addlegend = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{reproData}}

\item{xlab}{a label for the \eqn{X}-axis, by default \code{Concentration}}

\item{ylab}{a label for the \eqn{Y}-axis, by default \code{Nb of offspring per ind.day}}

\item{main}{main title for the plot}

\item{ylim}{\eqn{Y}-axis limits}

\item{target.time}{a numeric value corresponding to some observed time points in \code{data}}

\item{style}{graphical backend, can be \code{'ggplot'} or \code{'generic'}}

\item{log.scale}{if \code{TRUE}, displays \eqn{X}-axis in log-scale}

\item{remove.someLabels}{if \code{TRUE}, removes 75\% of \eqn{X}-axis labels in
\code{'ggplot'} style to avoid the label overlap}

\item{axis}{if \code{TRUE} displays ticks and label axis}

\item{addlegend}{if \code{TRUE}, adds a default legend to the plot}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plotDoseResponse} S3 method for the \code{reproData}
class. It plots the number of offspring per individual-days as a function of
concentration at a given target time.
}
\details{
The function plots the observed values of the reproduction rate (number of
reproduction outputs per individual-day) at a given time point as a function of
concentration. The 95 \% Poisson confidence interval is added to each reproduction
rate. It is calculated using function \code{\link[epitools]{pois.exact}}
from package \code{epitools}.
As replicates are not pooled in this plot, overlapped points are shifted on
the x-axis to help the visualization of replicates.
}
\note{
When \code{style = "generic"}, the function calls the generic function
\code{\link[graphics]{plot}}

When \code{style = "ggplot"}, the function return an object of class
\code{ggplot}, see function \code{\link[ggplot2]{ggplot}}
}
\seealso{
\code{\link[epitools]{pois.exact}}
}
\keyword{plot}
