% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{backwards}
\alias{backwards}
\title{Shift start time of potential mortalities earlier}
\usage{
backwards(data, morts, ID, station, res.start, stnchange = NULL)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, and duration. Residence events should be
continuous (i.e., not subset by season).}

\item{morts}{a dataframe containing potential mortalities. Must use
#' the same column names and in the same order as \code{data}.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt if \code{type="manual"}.}

\item{stnchange}{a dataframe with the start time and location of the most
recent station or location change. Must use the same column names and in
the same order as \code{data}.}
}
\value{
a dataframe with one row for each tag ID, including the date/time of
the residence start when the potential mortality or expelled tag was identified.
Returns the input \code{morts} dataframe if no potential mortalities are shifted
earlier.
All input data fields
(e.g., any name, location, or species information that was included with the
input data) will be retained.
}
\description{
Shift the start time of potential mortalities earlier, if
station/location has not changed.
}
\examples{
morts<-morts(data=events,type="mort",ID="ID",station="Station.Name",
method="any")
head(morts)

# If station change not identified yet:
morts_bw<-backwards(data=events,morts=morts,ID="ID",
station="Station.Name",res.start="ResidenceStart")
head(morts_bw)

# Identify station change first:
station.change<-stationchange(data=events,type="mort",
ID="ID",station="Station.Name")

morts_bw<-backwards(data=events,morts=morts,ID="ID",
station="Station.Name",res.start="ResidenceStart",
stnchange=station.change)
head(morts_bw)
}
