% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mort.R
\name{morts}
\alias{morts}
\title{Identify potential mortalities or expelled tags}
\usage{
morts(
  data,
  type = "mort",
  ID,
  station,
  res.start = "auto",
  res.end = "auto",
  method = "all",
  units = "auto",
  residences = "auto",
  singles = TRUE,
  backwards = FALSE,
  drift = "none",
  ddd = NULL,
  from.station = NULL,
  to.station = NULL,
  drift.cutoff = NULL,
  drift.units = NULL,
  season.start = NULL,
  season.end = NULL,
  season.overlap = TRUE,
  morts.prev = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, end time, and duration.}

\item{type}{the method used to generate the residence events. Options are
"mort", "actel", "glatos", "vtrack", or "manual". If "manual", then user
must specify \code{ID}, \code{station}, \code{res.start}, \code{res.end}, \code{residences}, and \code{units}.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{res.end}{a string of the name of the column in \code{data} that holds the
end date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{method}{the method to be used in flagging mortalities. Options are
"last", "any", "cumulative", or "all"}

\item{units}{units of the duration of the residence events in \code{data}.}

\item{residences}{a character string with the name of the column in \code{data}
that holds the duration of the residence events.}

\item{singles}{specifies if single detections (length of residence event = 0)
should be retained. Default is \code{TRUE}. Note that if single detections are
removed (\code{singles=FALSE}), \code{backwards} will also not include single detections.}

\item{backwards}{option to examine residence events prior to the one that was
flagged as a potential mortality. If prior residence events are at the same
station/location as the flagged event, the time of the potential mortality is shifted
earlier. Note that if \code{backwards=TRUE}, then the output of \code{method="last"} is
the same as \code{method="any"}.}

\item{drift}{option to account for potential drifting in identifying
thresholds and/or mortalities. Options are "none", "threshold",
"morts", "both". Default is "none".}

\item{ddd}{a dataframe of stations/locations where detected movement between
stations may be due to drifting of an expelled tag or dead animal.}

\item{from.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may start from. Must
be identical to the station/location names in \code{data}.}

\item{to.station}{a string of the name of the column in \code{ddd} that contains
the station/location names where drifting detections may move to. Must
be identical to the station/location names in \code{data}.}

\item{drift.cutoff}{the maximum allowable time difference between detections to be
considered a single residence event. Recommended to be the same as used
to generate residence events in \code{data}.}

\item{drift.units}{the units of the cutoff. Options are "secs", "mins", "hours",
"days", and "weeks". Recommended to be the same as used to generate
residence events in \code{data}.}

\item{season.start}{the start date/time(s) of the period of interest. If the
period of interest is the same in all study years, must be a character string
in format "dd-mm". Otherwise, must be in POSIXt, or a character string in
format YYYY-mm-dd HH:MM:SS.}

\item{season.end}{the end date/time(s) of the period of interest. If the
period of interest is the same in all study years, must be a character string
in format "dd-mm". Otherwise, must be in POSIXt, or a character string in
format YYYY-mm-dd HH:MM:SS.}

\item{season.overlap}{option to include residence events that overlap either the
beginning or the end of the period of interest. If \code{TRUE}, the full overlapping
residence events will be retained. If \code{FALSE}, only the portion of the
residence events that is within the period of interest will be retained,
and \code{residences} will be recalculated, using specified \code{units}.
Default is \code{TRUE}}

\item{morts.prev}{a dataframe containing potential mortalities. The dataframe must
have the same columns and in the same order as \code{data}.}

\item{verbose}{option to display updates and progress bars as
sub-functions are called and run. Default is TRUE.}

\item{season}{a dataframe with start and end dates of the season(s) of interest}
}
\value{
a dataframe with one row for each tag ID, including the date/time of
the residence start when the potential mortality or expelled tag was identified.
All input data fields
(e.g., any name, location, or species information that was included with the
input data) will be retained.
}
\description{
Identifies potential mortalities or expelled tags from passive
acoustic telemetry data. Mortalities are identified based on thresholds
derived from the dataset itself.
}
\examples{
morts_ex<-morts(data=events,type="mort",ID="ID",
station="Station.Name",method="any",verbose=FALSE)
head(morts_ex)

morts_ex_bw<-morts(data=events,type="mort",ID="ID",
station="Station.Name",method="any",backwards=TRUE,verbose=FALSE)
head(morts_ex_bw)
}
