% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mortsplot}
\alias{mortsplot}
\title{Plot residence events}
\usage{
mortsplot(
  data,
  type,
  ID,
  station,
  res.start = "auto",
  res.end = "auto",
  morts = NULL,
  singles = TRUE,
  interactive = FALSE,
  residences = NULL,
  units = NULL,
  season.start = NULL,
  season.end = NULL,
  facet = FALSE,
  facet.axis = "x",
  facet.by = "season",
  verbose = TRUE
)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, and end time.}

\item{type}{the method used to generate the residence events. Options are
"mort", "actel", "glatos", "vtrack", or "manual".}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{res.end}{a string of the name of the column in \code{data} that holds the
end date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{morts}{a dataframe containing potential mortalities. The dataframe must
have the same ID, station, res.start, res.end, and residences column names
as \code{data}.}

\item{singles}{option to adjust the end times of residence events so single
detection events are visible. Adjustment is for visualization purposes only
and should not obscure or impact the visualization of other residence events.}

\item{interactive}{option to generate an interactive plot.}

\item{residences}{an optional character string with the name of the column
in \code{data} that holds the duration of the residence events. Required if
generating an interactive plot or applying season.}

\item{units}{units of the duration of the residence events in \code{data}.
Required if applying season.}

\item{season.start}{the start date/time(s) of the period of interest. If the
period of interest is the same in all study years, must be a character string
in format "dd-mm". Otherwise, must be in POSIXt, or a character string in
format YYYY-mm-dd HH:MM:SS.}

\item{season.end}{the end date/time(s) of the period of interest. If the
period of interest is the same in all study years, must be a character string
in format "dd-mm". Otherwise, must be in POSIXt, or a character string in
format YYYY-mm-dd HH:MM:SS.}

\item{facet}{option to facet by year or season. If \code{TRUE}, then \code{season.start}
and \code{season.end} must be provided.}

\item{facet.axis}{option to position facets along x or y axis. Options are
"x" and "y". Default is "x". Note that \code{facet.axis} can only be "y" if
\code{facet.by="year"}.}

\item{facet.by}{option to facet by "season" (as defined with \code{season.start}
and \code{season.end}) or "year". Default is "season".}

\item{verbose}{option to display updates and progress bar as function is run.
Default is TRUE.}
}
\value{
a ggplot2 plot. Additional arguments (e.g., formatting axes,
legend, aes, manual colour scales) can be added as for any ggplot2 plot.
If \code{interactive=TRUE},
returns a plotly plot.
}
\description{
Plot residence events, with the option of plotting identified
mortalities. Plotting uses ggplot2. Interactive option also uses plotly.
}
\examples{
plot<-mortsplot(data=events,type="mort",ID="ID",station="Station.Name")
plot

# With mortalities plotted over residences:
morts<-morts(data=events,type="mort",ID="ID",station="Station.Name",
method="any",verbose=FALSE)

plot<-mortsplot(data=events,type="mort",ID="ID",station="Station.Name",
morts=morts)
plot
}
