% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rkrec}
\alias{rkrec}
\title{Generate Upper and Lower k-Records from Continuous Distributions}
\usage{
rkrec(size, k, record = c("upper", "lower"), dist, ...)
}
\arguments{
\item{size}{number of k-records to generate.}

\item{k}{the rank of the record to generate (\eqn{k}-record).}

\item{record}{the type of record to generate: \code{"upper"} for upper k-records,
\code{"lower"} for lower k-records. Default is \code{"upper"}.}

\item{dist}{a character string specifying the name of the continuous distribution
(e.g., \code{"norm"}, \code{"exp"}, \code{"gamma"}).}

\item{...}{further arguments to be passed to \code{dist}.}
}
\value{
A numeric vector of size \code{size}, representing the simulated k-records.
}
\description{
This function generates \eqn{k}-records (upper or lower) from a specified continuous distribution.
}
\details{
Note: Setting \code{k = 1} generates standard (1-)records.
}
\examples{
# Generate 5 upper 2-records from the normal distribution
rkrec(size = 5, k = 2, record = "upper", dist = "norm", mean = 0, sd = 1)

# Generate 5 lower 3-records from the exponential distribution
rkrec(size = 5, k = 3, record = "lower", dist = "exp", rate = 1)

}
\seealso{
\code{\link{ros}}
}
