% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rpcens2}
\alias{rpcens2}
\title{Generate Progressive Type-II Censored Samples}
\usage{
rpcens2(n, R, dist, ...)
}
\arguments{
\item{n}{total number of items in the sample.}

\item{R}{a vector of non-negative integers representing the number of items
censored at each stage of the experiment. The length of \code{R} determines
the number of failure stages (\code{m}), and the sum of \code{R} plus \code{m}
must equal \code{n}.}

\item{dist}{a character string specifying the name of the distribution
(e.g., \code{"norm"} for the normal distribution, \code{"exp"} for the exponential distribution).}

\item{...}{further arguments to be passed to \code{dist}.}
}
\value{
A numeric vector of size \code{m}, representing the failure times of the observed items.
}
\description{
This function generates progressive Type-II censored samples based on the
algorithm provided by Balakrishnan and Sandhu (1995).
}
\details{
This function implements the algorithm described by Balakrishnan and Sandhu (1995)
to simulate progressive Type-II censored samples. Progressive Type-II censoring
is a common scheme in reliability and life-testing experiments, where items are
progressively removed (censored) during the testing process.
}
\examples{
# Generate a progressive Type-II censored sample from the normal distribution
n <- 10
R <- c(2, 1, 2, 0, 0)
rpcens2(n, R, dist = "norm", mean = 0, sd = 1)

# Generate a progressive Type-II censored sample from the exponential distribution
rpcens2(n = 10, R = c(2, 2, 1, 0, 0), dist = "exp", rate = 1)

}
\references{
Balakrishnan, N., & Sandhu, R. A. (1995). \emph{A simple simulational algorithm for generating progressive
Type-II censored samples.} The American Statistician, 49(2), 229-230.
}
\seealso{
\code{\link{rcens}}
}
