#' Gas  and electricity usage by a home in St. Paul, MN
#'
#' @details A college mathematics professor teaching in St. Paul, Minnesota, USA collected these records
#' of his utility  bills starting in 1999. Starting in June 2022,
#' solar photovoltaics were installed on the roof of the house. There are months missing, a few transcription errors, etc.
#' **These data will be updated occasionally, as new bills come in.**
#'
#'
#' @docType data
#'
#' @usage data(Home_utilities)
#'
#' @format A data.frame object with one row for each month
#'
#' - `month` - the month covered by the bill as a number
#' - `day` - the terminating day of the bill
#' - `year` - the year in which the month fell
#' - `temp` -  average temperature over the entire  month
#' - `kwh` - electricity usage in kilowatt-hours
#' - `ccf` - natural gas usage in cubic feet
#' - `thermsPerDay` - another measure of natural gas usage
#' - `dur` - duration of the period covered by the bill, in days (typically about 30)
#' - `totalbill` - dollar amount of the bill
#' - `gasbill`: - dollar amount of the natural gas  part of the bill
#' - `elecbill` - dollar amount of the electricity bill
#' - `generatedKwh` - Energy generated by the photovoltaic system
#' - `notes` - miscellaneous  comments on the month's bill or changes in the house
#'
#' @keywords datasets
#'
#' @source  Personal communication from the homeowner
"Home_utilities"
