% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{motifs_distribution}
\alias{motifs_distribution}
\title{Compute statistical properties (expectation and variance) of the distribution
of motifs in a baseline model}
\usage{
motifs_distribution(
  net,
  motifs,
  lvl_attr = "sesType",
  model = "erdos_renyi",
  level = -1,
  omit_total_result = TRUE,
  directed = NULL
)
}
\arguments{
\item{net}{network object}

\item{motifs}{list of motif identifiers describing the motifs whose
distribution shall be analysed}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{model}{baseline model to be used. options are "erdos_renyi" and "actors_choice".
Defaults to "erdos_renyi".}

\item{level}{Additional parameter to set the level to vary for the
actors_choice model manually. All other levels are held fixed.}

\item{omit_total_result}{whether total results shall be omitted}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
data frame with one column giving names of motif identifers and two
  column giving expectation and variances per motif. For other motifs,
  expectations are computed but variances are returned as NaN.
}
\description{
This function supports the Erdős-Rényi Model (\code{erdos_renyi}) and the the
Actor’s Choice Model (\code{actors_choice}). The model can be specified using
the \code{model} parameter. The Erdős-Rényi Model can be used without
providing further parameters. In case of the Actor’s Choice Model a level of
the given network can be specified which is only level assumed to be
variable. All other levels are assumed to be fixed. Per default, \code{level
= -1}, the first level carrying two nodes in the signature of the motif is
selected as variable level. Set the \code{level} parameter to the value of
the \code{lvl_attr} of the nodes in the desired level to specify the level
manually.
}
\examples{
\dontrun{
motifs_distribution(ml_net, motif = list("1,2[I.C]"), directed = FALSE)
}
}
