% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps_critical_edges.R
\name{plot_gaps}
\alias{plot_gaps}
\title{Plot gaps in network visualisation}
\usage{
plot_gaps(
  net,
  motif,
  lvl_attr = c("sesType"),
  level = -1,
  cutoff = 2,
  subset_graph = "none",
  ...
)
}
\arguments{
\item{net}{Statnet network object}

\item{motif}{Motif to explore gaps in for}

\item{lvl_attr}{Node attribute specifying level information}

\item{level}{Focal level for gap analysis}

\item{cutoff}{Cut-off point in contributions of an edge to the number of
motifs above which to analyse gaps}

\item{subset_graph}{Whether to subset the graph to only show nodes involved
in gaps. One of "none" (no subset, default), "partial" (only focal level is
subset) or "focal" (only focal level shown)}

\item{...}{list of additional parameters to be passed to plotting function
(see \code{motifr::plot_mnet}), e.g. \code{label = TRUE}}
}
\value{
A plot of gaps, sized by weight in a multilevel network
}
\description{
Note that this only works for undirected graphs. Regardless of whether the
input graph is directed it is treated as undirected graph.
}
\examples{
\dontrun{
plot_gaps(ml_net, "1,2[II.C]", level = -1)
plot_gaps(ml_net, "1,2[II.C]",
  level = -1,
  subset_graph = "focal", cutoff = 4, label = TRUE
)
plot_gaps(ml_net, "1,2[II.C]",
  level = -1,
  subset_graph = "partial", cutoff = 4, label = TRUE
)
}
}
