% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_mnet.R
\name{plot_mnet}
\alias{plot_mnet}
\title{Visualize a multi-level network (using ggraph)}
\usage{
plot_mnet(
  net,
  lvl_attr = c("sesType"),
  layouts = rep("kk", n_levels),
  label = FALSE,
  directed = NULL,
  nodesize = 3,
  edgewidth = 0.5
)
}
\arguments{
\item{net}{A tidygraph, igraph or statnet network object}

\item{lvl_attr}{The name of the categorical node attribute specifying at
which level a node is situated}

\item{layouts}{A list of layouts (see \code{ggraph::layout_ggraph}) for every level
e.g. for two levels \code{list("auto","circle")}}

\item{label}{logical - should nodes be labelled? (defaults to false)}

\item{directed}{whether the network object shall be interpreted as directed
network. Per default, \code{motifr::is.directed} is used to determine that.}

\item{nodesize}{The size of node displays, if displayed as points (if label = false)}

\item{edgewidth}{The width of lines illustrating edges}
}
\value{
A ggraph object
}
\description{
Visualize a multi-level network, with the possibility of specifying separate
layouts for each level. This is a somewhat hacky wrapper for arranging
separate ggraph calls for each network level in a circle.
}
\details{
For more extensive visualization options, it is recommended to explore the
\link[graphlayouts]{layout_as_multilevel} function included in
the package graphlayouts.
}
\examples{
plot_mnet(net = motifr::ml_net, lvl_attr = "sesType", layouts = list("kk", "circle"))
}
