% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_check}
\alias{md_check}
\title{Assess output convergence in simulation outputs}
\usage{
md_check(
  obj,
  m = NULL,
  tol = 0.05,
  n_converge = 10,
  plot = TRUE,
  pal = c("#007d80", "#A12C3B")
)
}
\arguments{
\item{obj}{A \code{movedesign} or related object returned by
\code{\link[=md_run]{md_run()}} or \code{\link[=md_replicate]{md_replicate()}}.}

\item{m}{Numeric (optional). If provided, restricts the convergence
check to results for a specific population sample size (\code{m}).
Defaults to \code{NULL}, which checks up to the maximum population
sample size.}

\item{tol}{Numeric. The tolerance threshold for absolute change in
the cumulative mean to declare convergence. Defaults to
\code{0.05}.}

\item{n_converge}{Integer. Number of consecutive steps within
tolerance required to confirm convergence. Defaults to \code{10}.}

\item{plot}{Logical. If \code{TRUE} (default), generates a plot of
stepwise changes in the cumulative mean, highlighting when
convergence is achieved.}

\item{pal}{Character vector of color(s) of the plot, such as
\code{c("#007d80", "#A12C3B")}) (default).}
}
\value{
An object of class \code{"movedesign_check"} with the
following elements:
\describe{
\item{\code{has_converged}}{
Logical scalar indicating whether convergence was achieved.}
\item{\code{recent_deltas}}{
Numeric vector of absolute changes in cumulative mean
over the last \code{n_converge} steps.}
\item{\code{max_delta}}{
Maximum absolute change among the last steps.}
\item{\code{tolerance}}{
Numeric, the input tolerance \code{tol}.}
\item{\code{n_converge}}{
Integer, the input \code{n_converge}.}
\item{variable}{
Character. Name of the variable checked.}
\item{recent_cummean}{Numeric vector.
The last cumulative means checked.}
}
}
\description{
Evaluates whether the cumulative mean of a tracked error metric in
simulation outputs has stabilized, indicating convergence. This
function helps determine if repeated simulations or resampling have
produced stable estimates, which is critical for reliable inference
in animal movement projects.

Use this function after running \code{md_run()} or
\code{md_replicate()} to check the reliability of outputs
before further interpretation or reporting.
}
\details{
The cumulative mean of error is calculated, and the absolute changes
over the last \code{n_converge} steps are inspected. If all are
below the specified tolerance, convergence is declared.

If \code{plot = TRUE}, a plot is shown of absolute stepwise change
in the cumulative mean, with a shaded region indicating the
convergence threshold, aiding visual assessment.
}
\examples{
if(interactive()) {
  # After running a simulation or resampling:
  md_check(output, tol = 0.05, n_converge = 10)
}

}
\seealso{
\code{\link[=md_run]{md_run()}},
\code{\link[=md_replicate]{md_replicate()}}
}
