% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_prepare}
\alias{md_prepare}
\title{Prepare movement study design inputs}
\usage{
md_prepare(
  species = NULL,
  data,
  models = NULL,
  n_individuals = NULL,
  dur = NULL,
  dti = NULL,
  set_target = c("hr", "ctsd"),
  which_meta = "mean",
  add_individual_variation = FALSE,
  groups = NULL,
  parallel = FALSE
)
}
\arguments{
\item{species}{Character. Scientific or common name of the focal
species used as a workflow label.}

\item{data}{A named list of telemetry objects (from
\code{ctmm::as.telemetry()}) to be used as the empirical basis for the
simulations. Each telemetry object must contain valid metadata
and timestamped locations.}

\item{models}{(Optional) Named list of fitted ctmm models (from
\code{ctmm::ctmm.fit()} or \code{ctmm::ctmm.select()}). If not supplied,
models are fitted automatically.}

\item{n_individuals}{Integer. Number of animals (tags) to include
in the study design; defines the target \emph{population} sample size.}

\item{dur}{A list with elements \code{value} and \code{unit} (e.g.,
\code{list(value = 2, unit = "months")}), for the study's maximum
duration. \code{unit} must be either \code{"second"}, \code{"minute"}, \code{"hour"},
\code{"day"}, \code{"month"}, or \code{"year"}.}

\item{dti}{A list with elements \code{value} and \code{unit} (e.g.,
\code{list(value = 1, unit = "day")}), specifying the intended
sampling interval between relocations. \code{unit} must be either
\code{"second"}, \code{"minute"}, \code{"hour"}, \code{"day"}, \code{"month"}, or \code{"year"}.}

\item{set_target}{Character. Specifies the primary research target(s):
must be either \code{hr} (home range estimation), \code{ctsd}
(movement speed), or a character vector including both. This
argument controls which target metrics are processed, analyzed,
and reported in the study design workflow.}

\item{which_meta}{Character. Specifies the analytical target for
population-level inference: \code{NULL}, \code{"mean"} (default), or
\code{"ratio"}. Use \code{NULL} for a single individual, \code{"mean"} for
population means, or \code{"ratio"} to compare group means
(requires \code{groups}).}

\item{add_individual_variation}{Logical. If \code{TRUE}, simulates
variation by drawing movement parameters from the population
distribution.}

\item{groups}{(Optional) A named list for group assignments.
Each element is a character vector of individual names
(matching \code{data}). For example,
\code{list(A = c("id1", "id2"), B = c("id3", "id4"))} for groups
"A" and "B".Required when \verb{which_meta = \\"ratio\\"}.}

\item{parallel}{Logical. If \code{TRUE}, enables parallel processing
for model fitting, which speeds up analyses.}
}
\value{
An object of class \code{movedesign_input} (and \code{movedesign}). This is
a structured S3 list containing all validated inputs, model fits,
and derived parameters for the study design workflow.

The returned object includes:
\itemize{
\item \code{design}:
A \code{movedesign} object with all study settings and metadata.
\item \code{data}:
The original or validated list of telemetry objects.
\item \code{fitList}:
List of fitted movement models for each individual.
\item \code{meanfitList}:
List of population or group-level mean models.
\item \code{sigma}, \code{tau_p}, \code{tau_v}:
Movement parameters extracted from data provided for
downstream simulations.
\item \code{mu}: List of mean locations.
\item \code{groups}: Group structure if specified, otherwise \code{NULL}.
\item Other slots describing \emph{population} sample size, sampling
duration, sampling interval, targets, and workflow options.
}

This object is ready for use in downstream \code{movedesign} output
and diagnostic functions.
}
\description{
Prepares, validates, and organizes all required inputs and parameters
for evaluating the study design of animal movement projects. This
function checks data inputs, fits or verifies movement models,
extracts key parameters, and consolidates all settings in a
structured object for easy and reproducible downstream use.
}
\details{
This function is designed to streamline and standardize the preparation
of input data and study design parameters for simulation-based movement
ecology analyses. It performs the following key steps:
\itemize{
\item Validates that \code{data} is a non-empty list of telemetry
objects with metadata and location records.
\item Fits movement models to each individual if not supplied.
\item Checks supplied movement models for validity.
\item Extracts parameters (e.g., \code{sigma}, \code{tau_p}, \code{tau_v})
for simulation.
\item Gathers settings (sample size, duration, sampling, grouping)
into a single object.
}
}
\examples{
if(interactive()) {
  data(buffalo)
  input <- md_prepare(
    data = buffalo,
    models = models,
    species = "buffalo",
    n_individuals = 5,
    dur = list(value = 1, unit = "month"),
    dti = list(value = 1, unit = "day"),
    add_individual_variation = TRUE,
    set_target = "hr",
    which_meta = "mean")
 summary(input)
}

}
\concept{workflow_steps}
