% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_sims.R
\name{simulating_data}
\alias{simulating_data}
\title{Simulate movement data from continuous-time movement models}
\usage{
simulating_data(rv, seed)
}
\arguments{
\item{rv}{A \code{reactiveValues} object with all simulation inputs:
\itemize{
\item dur A list with elements \code{value} and \code{unit} (e.g.,
\code{list(value = 2, unit = "months")}), for the study's maximum
duration. \code{unit} must be either \code{"second"}, \code{"minute"},
\code{"hour"}, \code{"day"}, \code{"month"}, or \code{"year"}.
\item dti A list with elements \code{value} and \code{unit} (e.g.,
\code{list(value = 1, unit = "day")}), specifying the intended
sampling interval between relocations. \code{unit} must be either
\code{"second"}, \code{"minute"}, \code{"hour"}, \code{"day"}, \code{"month"},
or \code{"year"}.
\item \code{data_type}: Character, data source that informs the
simulations.
\item \code{add_ind_var}: Logical; if \code{TRUE}, draws parameters from
population distribution for each new individual.
\item \code{modList}: List of fitted models.
\item \code{meanfitList}: List of mean models for individual variation.
\item \code{grouped}: Logical; if \code{TRUE}, simulates from two groups.
\item \code{which_meta}: Character vector; analytical target.
\item \code{tau_p}, \code{tau_v}, \code{sigma}, \code{mu}: Lists of
movement parameters.
}}

\item{seed}{Integer for random number generator,
ensuring reproducibility.}
}
\value{
A list of simulated movement datasets:
\itemize{
\item If \code{grouped = FALSE}, a list with a single simulated track.
\item If \code{grouped = TRUE},
a list with two tracks (from groups A and B).
}
}
\description{
Generates simulated animal movement tracks based on continuous-time
movement models using \code{\link[ctmm:simulate.ctmm]{ctmm::simulate()}}. Supports both single-group
and grouped simulations, as determined by study design and data
parameters. Used within the \code{movedesign} application workflows to
create synthetic data for simulation studies and to evaluate study
design.
}
\details{
This function simulates animal movement tracks based on the selected
mode and design settings. It first constructs a time sequence using
the specified duration and interval. Depending on the simulation mode
(\code{data_type}), it either retrieves movement models from \code{modList}
(for simulated data) or uses \code{meanfitList} or raw movement parameters
to build models (for uploaded or selected data). If a group
comparison is requested, models are prepared for both groups.
Tracks are then simulated using \code{ctmm::simulate()} and subsequently
pseudonymized.
}
\note{
This function is intended for internal use and may assume inputs
follow specific structure and constraints not referenced explicitly.
}
\keyword{internal}
