% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{analyze_wavelet}
\alias{analyze_wavelet}
\title{Analyze Wavelet from View object}
\usage{
analyze_wavelet(
  obj,
  column,
  loess.span = 0,
  dj = 1/20,
  lowerPeriod = 2/obj$recording$fps,
  upperPeriod = 5,
  make.pval = TRUE,
  method = "white.noise",
  params = NULL,
  n.sim = 1,
  date.format = NULL,
  date.tz = NULL,
  verbose = TRUE
)
}
\arguments{
\item{obj}{View object.}

\item{column}{Column in view to analyse.}

\item{loess.span}{parameter alpha in loess controlling the degree of time series smoothing, if the time series is to be detrended; no detrending if loess.span = 0.
Default: 0.}

\item{dj}{frequency resolution. Default 1/20.}

\item{lowerPeriod}{lower Fourier period in seconds. Defaults to 2/fps.}

\item{upperPeriod}{upper Fourier period in seconds. Defaults to 5s.}

\item{make.pval}{see \code{\link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet()}}.}

\item{method}{see \code{\link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet()}}.}

\item{params}{see \code{\link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet()}}.}

\item{n.sim}{number of simulations (default 1).}

\item{date.format}{see \code{\link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet()}}.}

\item{date.tz}{see \code{\link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet()}}.}

\item{verbose}{see \code{\link[WaveletComp:analyze.wavelet]{WaveletComp::analyze.wavelet()}}.}
}
\value{
an \code{analyze.wavelet} object.
}
\description{
Analyze Wavelet from View object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
w <- analyze_wavelet(pv, "Nose_y")
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_sel_phases}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
