% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{visualise_sample_splices}
\alias{visualise_sample_splices}
\title{Visualise random splices}
\usage{
visualise_sample_splices(
  splicing_df,
  splicing_list,
  jv,
  overlay = TRUE,
  avoid_splice_list = list(),
  unstack = FALSE
)
}
\arguments{
\item{splicing_df}{\code{Splice} object.}

\item{splicing_list}{a list of \code{Splice} objects.}

\item{jv}{\code{JoinedView} object.}

\item{overlay}{overlay the segments for a density plot?}

\item{avoid_splice_list}{list of \verb{Splice objects} that determine times not to sample.}

\item{unstack}{overlay segments on top of each other? (default is FALSE).}
}
\value{
a \code{ggplot} object.
}
\description{
Visualise random splices
}
\examples{
r <- get_sample_recording()
fv_list <- get_filtered_views(r, data_points = 'Nose', n = 41, p = 3)
jv <- get_joined_view(fv_list)
splicing_df <- splice_time(list(a = c(0, 5), b = c(10, 15)))
splicing_list <- sample_offset_splice(splicing_df, jv, num_splices = 20)
visualise_sample_splices(splicing_df, splicing_list, jv)
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()}
}
\concept{statistical and analysis functions}
