% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_effect.R
\name{EC_effect}
\alias{EC_effect}
\title{Determine EC effects}
\usage{
EC_effect(
  trait_env_mean,
  crop_duration,
  EC_list,
  type,
  min_win = 20,
  sel_criteria = "global",
  plot = TRUE,
  plot_dir = NULL,
  p_title = "EC_plot",
  env_nm = NULL
)
}
\arguments{
\item{trait_env_mean}{vector of trait mean over environment.}

\item{crop_duration}{numerical value indicating the crop duration.}

\item{EC_list}{list EC parameter matrix. one per environment. The
order of the environment must be the same as the one of the trait
mean.}

\item{type}{character string vector indicating the type of statistic
that correspond to the EC. Either the cumulated sum ('sum') or the
average ('mean').}

\item{min_win}{Numerical value indicating the minimum size of the range
between start and end day when the EC values are measured. Default = 20}

\item{sel_criteria}{Character specifying the selection criteria.
Default = 'global'}

\item{plot}{Logical value indicating if a plot of the EC effects over time
should be returned. Default = FALSE,}

\item{plot_dir}{Directory where the plot should be returned. Default = NULL}

\item{p_title}{Title of the plot. Default = 'EC_plot'}

\item{env_nm}{Optional vector of environment name. Default = NULL.}
}
\value{
Return:

\code{data.frame} that contains the following elements for each EC (line).
The first line is the value of the EC in the different environments:

\enumerate{

\item{Start and end date of the optimal window}
\item{R2 of correlation between trait and EC}
\item{Direction of the correlation}
\item{Average R2 value over all tested windows}
\item{EC value in the different environments for the optimal time window}

}
}
\description{
Determine the effect of environmental covariates (EC) on the mean of a
trait across environments and the time range where this effect is the
strongest. The procedure was originally proposed by Li et al. (2018).
}
\references{
Li, X., Guo, T., Mu, Q., Li, X., & Yu, J. (2018). Genomic and environmental
determinants and their interplay underlying phenotypic plasticity.
Proceedings of the National Academy of Sciences, 115(26), 6679-6684.
}
\author{
Vincent Garin
}
