% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.HPWmapSphere.R
\name{plot.HPWmapSphere}
\alias{plot.HPWmapSphere}
\title{Plotting of pointwise and highest pointwise probabilities on a sphere.}
\usage{
\method{plot}{HPWmapSphere}(
  x,
  lon,
  lat,
  plotWhich = "Both",
  color = c("firebrick1", "gainsboro", "dodgerblue3"),
  turnOut = FALSE,
  title,
  ...
)
}
\arguments{
\item{x}{List containing the pointwise (PW) and highest pointwise (HPW)
probabilities of all differences of smooths.}

\item{lon}{Vector containing the longitudes of the data points.}

\item{lat}{Vector containing the latitudes of the data points.}

\item{plotWhich}{Which probabilities shall be plotted? \code{HPW}, \code{PW}
or \code{Both}?}

\item{color}{Vector of length 3 containing the colors to be used in the 
credibility maps. The first color represents the credibly negative pixels, 
the second color the pixels that are not credibly different from zero
and the third color the credibly positive pixels.}

\item{turnOut}{Logical. Should the output images be turned 90 degrees 
counter-clockwise?}

\item{title}{Vector containing one string per plot. The required 
number of titles is equal to \code{length(mrbOut$hpout)}. If no \code{title} 
is passed, defaults are used.}

\item{...}{Further graphical parameters can be passed.}
}
\value{
Plots of pointwise and/or highest pointwise probabilities for all
    differences of smooths are created.
}
\description{
Maps with pointwise (PW) probabilities and/or highest pointwise (HPW) 
probabilities of all differences of smooths at neighboring scales are plotted. 
Continental lines are added.
}
\details{
The default colors of the maps have the following meaning:
\itemize{
\item \strong{Blue}: Credibly positive pixels.
\item \strong{Red}: Credibly negative pixels.
\item \strong{Grey}: Pixels that are not credibly different from zero.
}
\code{x} corresponds to the \code{hpout}-part of the
output of \code{\link{mrbsizeRsphere}}.
}
\examples{
# Artificial spherical sample data
set.seed(987)
sampleData <- matrix(stats::rnorm(2000), nrow = 200)
sampleData[50:65, ] <- sampleData[50:65, ] + 5
lon <- seq(-180, 180, length.out = 20)
lat <- seq(-90, 90, length.out = 10)

# mrbsizeRsphere analysis
mrbOut <- mrbsizeRsphere(posteriorFile = sampleData, mm = 20, nn = 10, 
                         lambdaSmoother = c(0.1, 1), prob = 0.95)
                           
# Posterior mean of the differences of smooths
plot(x = mrbOut$smMean, lon = lon, lat = lat,
     color = fields::tim.colors()) 

# Credibility analysis using pointwise (PW) maps
plot(x = mrbOut$hpout, lon = lon, lat = lat, plotWhich = "PW")

# Credibility analysis using highest pointwise probability (HPW) maps
plot(x = mrbOut$hpout, lon = lon, lat = lat, plotWhich = "HPW")

}
