% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flnl.grad.R
\name{flnl.grad}
\alias{flnl.grad}
\title{Gradient of the negative log likelihood function}
\usage{
flnl.grad(pars, ddfobj, misc.options, fitting = "all")
}
\arguments{
\item{pars}{vector of parameter values for the detection function at which 
the gradients of the negative log-likelihood should be evaluated}

\item{ddfobj}{distance sampling object}

\item{misc.options}{a list object containing all additional information such 
as the type of optimiser or the truncation width, and is created by 
\code{\link{ddf.ds}}}

\item{fitting}{character string with values "all", "key", "adjust" to
determine which parameters are allowed to vary in the fitting. Not actually
used. Defaults to "all".}
}
\value{
The gradients of the negative log-likelihood w.r.t. the parameters
}
\description{
This function derives the gradients of the negative log likelihood function, 
with respect to all parameters. It is based on the theory presented in 
Introduction to Distance Sampling (2001) and Distance Sampling: Methods and
Applications (2015). It is not meant to be called by users of the \code{mrds}
and \code{Distance} packages directly but rather by the gradient-based 
solver. This solver is used when our distance sampling model is for 
single-observer data coming from either line or point transect and only when  
the detection function contains an adjustment series but no covariates. It is 
implement for the following key + adjustment series combinations for the 
detections function: the key function can be half-normal, hazard-rate or 
uniform, and the adjustment series can be cosine, simple polynomial or 
Hermite polynomial. Data can be either binned or exact, but a combination
of the two has not been implemented yet.
}
\author{
Felix Petersma
}
