% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwrite.R
\name{mread_yaml}
\alias{mread_yaml}
\alias{yaml_to_cpp}
\title{Read a model from yaml format}
\usage{
mread_yaml(
  file,
  model = basename(file),
  project = tempdir(),
  update = FALSE,
  ...
)

yaml_to_cpp(file, model = basename(file), project = getwd(), update = TRUE)
}
\arguments{
\item{file}{the yaml file name.}

\item{model}{a new model name to use when calling \code{mread_yaml()}.}

\item{project}{the directory where the model should be built.}

\item{update}{\code{TRUE} if model settings should be written into the cpp file in
a \verb{$SET} block.}

\item{...}{passed to \code{\link[=mread]{mread()}}.}
}
\value{
A model object.
}
\description{
Read back models written to file using \code{\link[=mwrite_yaml]{mwrite_yaml()}}. Function
\code{yaml_to_cpp()} is also provided to convert the yaml file to mrgsolve cpp
file format.
}
\details{
Note that \code{yaml_to_cpp()} by default writes model settings into the cpp
file. \code{mread_yaml()} does not write model settings into the file but rather
update the model object directly with data read back from the \code{yaml} file.
}
\examples{
mod <- house()

temp <- tempfile(fileext = ".yaml")

mwrite_yaml(mod, file = temp)

# Note: this model is not compiled
mod <- mread_yaml(temp, model = "new-house", compile = FALSE)
mod

cppfile <- yaml_to_cpp(temp, project = tempdir())

readLines(cppfile)

}
\seealso{
\code{\link[=mwrite_yaml]{mwrite_yaml()}}
}
