% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mHBT.R
\name{mHBT}
\alias{mHBT}
\title{Multivariate Small Area Estimation using Hierarchical Bayesian under T Distribution}
\usage{
mHBT(
  formula,
  vardir,
  iter.update = 3,
  iter.mcmc = 10000,
  thin = 2,
  burn.in = 2000,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula, describe the model to be fitted}

\item{vardir}{vector containing name of sampling variances of direct estimators  in the following order : \code{var1, var2, . , var(k) , cov12, . cov1k, cov23, . , cov(k-1)(k)}}

\item{iter.update}{number of updates with default \code{3}}

\item{iter.mcmc}{number of total iterations per chain with default \code{10000}}

\item{thin}{thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{number of iterations to discard at the beginning with default \code{2000}}

\item{data}{dataframe containing the variables named in \code{formula} and \code{vardir}}
}
\value{
The function returns a list with the following objects:
\describe{
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
}
}
\description{
This function implements small area estimation using hierarchical bayesian to variable of interest that assumed to be a multivariate T distribution.
}
\examples{
  ## Load dataset
  data(datasaeT)
  ## Using parameter 'data'
  Fo <- list(f1=Y1~X1+X2,
             f2=Y2~X1+X2)
  vardir <- c("v1", "v2", "v12")
  m1 <- mHBT(formula=Fo, vardir=vardir,
  iter.update = 1, iter.mcmc = 1000,
  thin = 2, burn.in = 200, data=datasaeT)

}
