% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mscp.r
\name{mscp}
\alias{mscp}
\title{mscp}
\usage{
mscp(x, delta = 20, g = 20, kappa = NA, alpha = 0.01, sim = 500)
}
\arguments{
\item{x}{numeric vector. Input sequence of random variables.}

\item{delta}{integer >=2. Default = 20. Minimal window considered.}

\item{g}{integer >=1. Default = 20. Spacing between starting points.}

\item{kappa}{NA or positive real number. Default = NA. Breaking threshold. If NA, then kappa is derived in simulations, using alpha and sim}

\item{alpha}{numeric in (0,1). Default = 0.01. Significance level, i.e., sets kappa as (1-alpha)-quantile of maximum of Gaussian process limit.}

\item{sim}{integer >=1. Default = 500. Number of simulations for kappa.}
}
\value{
invisible list
\item{cp}{detected change points (ordered according to detection)}
\item{mean_sd}{matrix of estimated means and standard deviations}
\item{path}{list containing matrices, each matrix describing the path of a detected change point. First column: t-value, second column: h-value, third column: D-value (statistic), first row: starting values, last row: end values}
\item{S}{matrix of possible starting values. First column: t-value, second column: h-value, third column: D-value (statistic), fourth column: step when cut out}
\item{x}{input sequence}
\item{delta}{minimal window size}
\item{g}{spacing between starting points}
\item{kappa}{threshold}
}
\description{
Multiscale change point detection via gradual bandwidth adjustment in moving sum processes. A method for the detection of changes in the expectation in univariate sequences.
}
\examples{
set.seed(1)
Tt <- 1000
cp <- c(250,500,600,650,750)
mu <- c(2,3,6,9,12,15)
sd <- c(1,1,2,1,2,1)
m  <- rep(mu,diff(c(0,cp,Tt))) 
s  <- rep(sd,diff(c(0,cp,Tt)))    
x  <- rnorm(Tt,m,s)
result <- mscp(x,kappa=4.77) # kappa set manually
# result <- mscp(x) # kappa derived in simulations
summary(result)
plot(result)

}
\references{
Multiscale change point detection via gradual bandwidth adjustment in moving sum processes (2021+), Tijana Levajkovic and Michael Messer
}
\seealso{
\code{\link{plot.mscp}, \link{summary.mscp}}
}
\author{
Tijana Levajkovic and Michael Messer
}
