# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Calculate spectral entropy of a spectrum
#' @description Calculate spectral entropy of a spectrum
#'
#' @param peaks A matrix of peaks, with two columns: m/z and intensity.
#' @return A double value of spectral entropy.
#'
#' @examples
#' mz <- c(100.212, 300.321, 535.325)
#' intensity <- c(37.16, 66.83, 999.0)
#' peaks <- matrix(c(mz, intensity), ncol = 2, byrow = FALSE)
#' calculate_spectral_entropy(peaks)
#'
calculate_spectral_entropy <- function(peaks) {
    .Call(`_msentropy_r_calculate_spectral_entropy`, peaks)
}

#' @title Clean a spectrum
#' @description Clean a spectrum
#'
#' This function will clean the peaks by the following steps:
#' 1. Remove empty peaks (mz <= 0 or intensity <= 0).
#' 2. Remove peaks with mz >= max_mz or mz < min_mz.
#' 3. Centroid the spectrum by merging peaks within min_ms2_difference_in_da or min_ms2_difference_in_ppm.
#' 4. Remove peaks with intensity < noise_threshold * max_intensity.
#' 5. Keep only the top max_peak_num peaks.
#' 6. Normalize the intensity to sum to 1.
#'
#' Note: The only one of min_ms2_difference_in_da and min_ms2_difference_in_ppm should be positive.
#'
#' @param peaks A matrix of spectral peaks, with two columns: mz and intensity
#' @param min_mz The minimum mz value to keep, set to -1 to disable
#' @param max_mz The maximum mz value to keep, set to -1 to disable
#' @param noise_threshold The noise threshold, set to -1 to disable, all peaks have intensity < noise_threshold * max_intensity will be removed
#' @param min_ms2_difference_in_da The minimum mz difference in Da to merge peaks, set to -1 to disable, any two peaks with mz difference < min_ms2_difference_in_da will be merged
#' @param min_ms2_difference_in_ppm The minimum mz difference in ppm to merge peaks, set to -1 to disable, any two peaks with mz difference < min_ms2_difference_in_ppm will be merged
#' @param max_peak_num The maximum number of peaks to keep, set to -1 to disable
#' @param normalize_intensity Whether to normalize the intensity to sum to 1
#'
#' @return A matrix of spectral peaks, with two columns: mz and intensity
#' @export
#'
#' @examples
#' mz <- c(100.212, 169.071, 169.078, 300.321)
#' intensity <- c(0.3716, 7.917962, 100., 66.83)
#' peaks <- matrix(c(mz, intensity), ncol = 2, byrow = FALSE)
#' clean_spectrum(peaks, min_mz = 0, max_mz = 1000, noise_threshold = 0.01,
#'                min_ms2_difference_in_da = 0.02, min_ms2_difference_in_ppm = -1,
#'                max_peak_num = 100, normalize_intensity = TRUE)
#'
clean_spectrum <- function(peaks, min_mz, max_mz, noise_threshold, min_ms2_difference_in_da, min_ms2_difference_in_ppm, max_peak_num, normalize_intensity) {
    .Call(`_msentropy_r_clean_spectrum`, peaks, min_mz, max_mz, noise_threshold, min_ms2_difference_in_da, min_ms2_difference_in_ppm, max_peak_num, normalize_intensity)
}

#' @title Unweighted entropy similarity between two spectra
#' @description Calculate the unweighted entropy similarity between two spectra
#'
#'
#' @param peaks_a A matrix of spectral peaks, with two columns: mz and intensity
#' @param peaks_b A matrix of spectral peaks, with two columns: mz and intensity
#' @param ms2_tolerance_in_da The MS2 tolerance in Da, set to -1 to disable
#' @param ms2_tolerance_in_ppm The MS2 tolerance in ppm, set to -1 to disable
#' @param clean_spectra Whether to clean the spectra before calculating the entropy similarity, see \code{\link{clean_spectrum}}
#' @param min_mz The minimum mz value to keep, set to -1 to disable
#' @param max_mz The maximum mz value to keep, set to -1 to disable
#' @param noise_threshold The noise threshold, set to -1 to disable, all peaks have intensity < noise_threshold * max_intensity will be removed
#' @param max_peak_num The maximum number of peaks to keep, set to -1 to disable
#'
#' @return The unweighted entropy similarity
#'
#' @examples
#' mz_a <- c(169.071, 186.066, 186.0769)
#' intensity_a <- c(7.917962, 1.021589, 100.0)
#' mz_b <- c(120.212, 169.071, 186.066)
#' intensity_b <- c(37.16, 66.83, 999.0)
#' peaks_a <- matrix(c(mz_a, intensity_a), ncol = 2, byrow = FALSE)
#' peaks_b <- matrix(c(mz_b, intensity_b), ncol = 2, byrow = FALSE)
#' calculate_unweighted_entropy_similarity(peaks_a, peaks_b,
#'                                        ms2_tolerance_in_da = 0.02, ms2_tolerance_in_ppm = -1,
#'                                        clean_spectra = TRUE, min_mz = 0, max_mz = 1000,
#'                                        noise_threshold = 0.01,
#'                                        max_peak_num = 100)
#'
calculate_unweighted_entropy_similarity <- function(peaks_a, peaks_b, ms2_tolerance_in_da, ms2_tolerance_in_ppm, clean_spectra, min_mz, max_mz, noise_threshold, max_peak_num) {
    .Call(`_msentropy_r_calculate_unweighted_entropy_similarity`, peaks_a, peaks_b, ms2_tolerance_in_da, ms2_tolerance_in_ppm, clean_spectra, min_mz, max_mz, noise_threshold, max_peak_num)
}

#' @title Entropy similarity between two spectra
#' @description Calculate the entropy similarity between two spectra
#'
#'
#' @param peaks_a A matrix of spectral peaks, with two columns: mz and intensity
#' @param peaks_b A matrix of spectral peaks, with two columns: mz and intensity
#' @param ms2_tolerance_in_da The MS2 tolerance in Da, set to -1 to disable
#' @param ms2_tolerance_in_ppm The MS2 tolerance in ppm, set to -1 to disable
#' @param clean_spectra Whether to clean the spectra before calculating the entropy similarity, see \code{\link{clean_spectrum}}
#' @param min_mz The minimum mz value to keep, set to -1 to disable
#' @param max_mz The maximum mz value to keep, set to -1 to disable
#' @param noise_threshold The noise threshold, set to -1 to disable, all peaks have intensity < noise_threshold * max_intensity will be removed
#' @param max_peak_num The maximum number of peaks to keep, set to -1 to disable
#'
#' @return The entropy similarity
#'
#' @examples
#' mz_a <- c(169.071, 186.066, 186.0769)
#' intensity_a <- c(7.917962, 1.021589, 100.0)
#' mz_b <- c(120.212, 169.071, 186.066)
#' intensity_b <- c(37.16, 66.83, 999.0)
#' peaks_a <- matrix(c(mz_a, intensity_a), ncol = 2, byrow = FALSE)
#' peaks_b <- matrix(c(mz_b, intensity_b), ncol = 2, byrow = FALSE)
#' calculate_entropy_similarity(peaks_a, peaks_b,
#'                              ms2_tolerance_in_da = 0.02, ms2_tolerance_in_ppm = -1,
#'                              clean_spectra = TRUE, min_mz = 0, max_mz = 1000,
#'                              noise_threshold = 0.01,
#'                              max_peak_num = 100)
#'
calculate_entropy_similarity <- function(peaks_a, peaks_b, ms2_tolerance_in_da, ms2_tolerance_in_ppm, clean_spectra, min_mz, max_mz, noise_threshold, max_peak_num) {
    .Call(`_msentropy_r_calculate_entropy_similarity`, peaks_a, peaks_b, ms2_tolerance_in_da, ms2_tolerance_in_ppm, clean_spectra, min_mz, max_mz, noise_threshold, max_peak_num)
}

