% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{MSThermExperiment}
\alias{MSThermExperiment}
\title{Create a new MSThermExperiment.}
\usage{
MSThermExperiment(control, annotations)
}
\arguments{
\item{control}{data frame or filename of tab-delimited table describing the
experimental setup and locations of data on disk (see Details)}

\item{annotations}{data frame or filename to tab-delimited table containing
protein names and annotations (usually functional descriptions but can be
any text}
}
\value{
An MSThermExperiment object
}
\description{
\code{MSThermExperiment} creates a new experiment object from
  a set of filenames or data frames.
}
\details{
Both parameters can take either a data frame or a tab-delimited
  filename on disk (which will be read into a data frame). "control" should
  contain columns with the following headers (in any order):
    \describe{
       \item{"name"}{Unique identifier of a single replicate}
       \item{"sample"}{Sample name that a replicate belongs to}
       \item{"data_file"}{Path to file on disk containing the quantification
           data}
       \item{"meta_file"}{Path to file on disk containing the labeling
           metadata}
    }
  The "meta_file" should be tab-delimited text and contain two columns
  labeled "channel" and "temp".
  The "data_file" should be tab-delimited text and contain, at a minimum,
  the following columns:
  \describe{
     \item{"peptide"}{Sequence of the matched peptide in single-letter IUPAC}
     \item{"protein"}{Protein or protein group to which the peptide belongs}
     \item{"..."}{One column per isobaric channel, containing absolute
        quantification values. Column names must match those in the
        "channel" column of the meta file, with the exception that R will
        automatically convert any name not compatible with its syntax
        rules. To be safe, use only letters, digits, underscores, and
        periods in channel names and never start with a digit (e.g. use "TMT.126"
        rather than "126")}
  }
  The following columns can also be utilized for filtering if included (all
  others will simply be ignored):
  \describe{
     \item{"coelute_inf"}{Calculated precursor co-isolation interference
        (0.0-1.0)}
     \item{"score"}{Score assigned by the processing software to the PSM}
  }
  "annotations" should contain two columns with the headers "name" and
  "annotation". "name" should match the protein names in the data files,
  and "annotation" can contain any text (generally a functional description)
}
\examples{
control <- system.file("extdata", "demo_project/control.tsv", package="mstherm")
annots  <- system.file("extdata", "demo_project/annots.tsv",  package="mstherm")
expt    <- MSThermExperiment(control, annotations=annots)

}
