% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{normalize_to_tm}
\alias{normalize_to_tm}
\title{Re-normalize based on Tm.}
\usage{
normalize_to_tm(expt, res)
}
\arguments{
\item{expt}{An MSThermExperiment object}

\item{res}{An MSThermResultSet object}
}
\value{
An MsThermExperiment object with re-normalized data slots
}
\description{
Normalizes each replicate of an experiment based on linear
regression of calculated Tm (corrects for remaining systematic error).
}
\details{
An assumption can be made in most TPP experiments using a single
organism that the Tm of most proteins should not be changing. However,
global shifts have been observed between replicates, presumably due to
technical variance, which complicate data interpretation. This method
attempts to remove this source of error by doing a bootstrap
renormalization of the quantification values based on pairwise linear
regression between calculated Tms of each replicate. A reference set of Tms
is calculated based on all replicates, and each replicate is normalized to
this based on the calculated slope and intercept of the input data.
}
\examples{
control <- system.file("extdata", "demo_project/control.tsv", package="mstherm")
annots  <- system.file("extdata", "demo_project/annots.tsv",  package="mstherm")
expt    <- MSThermExperiment(control, annotations=annots)
expt    <- normalize_to_std(expt, "cRAP_ALBU_BOVIN", plot=FALSE)
res     <- model_experiment(expt, smooth=TRUE, bootstrap=FALSE, np=2)

expt    <- normalize_to_tm(expt, res)

}
