% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon_entropy.R
\name{multivar_joint_shannon_entropy}
\alias{multivar_joint_shannon_entropy}
\alias{multivar_joint_shannon_entropy}
\alias{multivar_joint_H}
\title{Estimation of joint Shannon entropy for a set of categorical variables.}
\usage{
multivar_joint_shannon_entropy(table_variables, table_class)

multivar_joint_H(table_variables, table_class)
}
\arguments{
\item{table_variables}{A list of factors as categorical variables.}

\item{table_class}{A factor representing the class of the case.}
}
\value{
Joint Shannon entropy estimation for the variable set
    {\code{table.variables}, \code{table.class}}.
}
\description{
The multivariate joint Shannon entropy provides an estimation of
the measure of the uncertainty associated with a set of variables (see 
\url{https://en.wikipedia.org/wiki/Joint_entropy}).
}
\examples{
multivar_joint_shannon_entropy(list(factor(c(0,1)), factor(c(1,0))),
    factor(c(1,1)))
}
\seealso{
\code{\link{shannon_entropy}} for the entropy for a
    single variable and
    \code{\link{joint_shannon_entropy}} for the entropy
    associated with two random variables.
}
