% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msu.R
\name{symmetrical_uncertainty}
\alias{symmetrical_uncertainty}
\alias{symmetrical_uncertainty}
\alias{SU}
\title{Estimating Symmetrical Uncertainty of two categorical variables.}
\usage{
symmetrical_uncertainty(x, y)

SU(x, y)
}
\arguments{
\item{x}{A factor as the represented categorical variable.}

\item{y}{A factor as the represented categorical variable.}
}
\value{
Symmetrical uncertainty estimation based on Sannon
    entropy. The result is \code{round}ed to 7 decimal places.
}
\description{
Symmetrical uncertainty (SU) is the product of a normalization of
the information gain (\code{\link[=information_gain]{IG}}) with
respect to entropy. SU(X,Y) is a value in the range [0,1], where
\eqn{SU(X,Y) = 0} if X and Y are totally independent and
\eqn{SU(X,Y) = 1} if X and Y are totally dependent.
}
\examples{
# completely predictable
symmetrical_uncertainty(factor(c(0,1,0,1)), factor(c(0,1,0,1)))
# XOR factor variables
symmetrical_uncertainty(factor(c(0,0,1,1)), factor(c(0,1,1,0)))
symmetrical_uncertainty(factor(c(0,1,0,1)), factor(c(0,1,1,0)))
\dontrun{
symmetrical_uncertainty(c(0,1,0,1), c(0,1,1,0))
}
}
\seealso{
\code{\link{msu}}
}
