% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LORgee.control.R
\name{LORgee_control}
\alias{LORgee_control}
\title{Control For The GEE Solver}
\usage{
LORgee_control(tolerance = 0.001, maxiter = 15, verbose = FALSE,
  TRACE = FALSE)
}
\arguments{
\item{tolerance}{positive convergence tolerance. The algorithm converges
when the maximum of the absolute relative difference in parameter estimates
is less than or equal to \code{tolerance}.}

\item{maxiter}{positive integer that indicates the maximum number of
iterations in the Fisher-scoring iterative algorithm.}

\item{verbose}{logical that indicates if output should be printed at each
iteration.}

\item{TRACE}{logical that indicates if the parameter estimates and the
convergence criterion at each iteration should be saved.}
}
\description{
Control variables for the GEE solver in the \link{nomLORgee} and
\link{ordLORgee} functions.
}
\examples{
data(arthritis)
fitmod <- ordLORgee(y ~ factor(trt) + factor(baseline) + factor(time),
  data = arthritis, id = id, repeated = time)

## A one-step GEE estimator
fitmod1 <- update(fitmod, control = LORgee_control(maxiter = 1))
coef(fitmod)
coef(fitmod1)


}
\seealso{
\link{nomLORgee} and \link{ordLORgee}.
}
\author{
Anestis Touloumis
}
